import { Repository } from 'typeorm';
import { Product } from '../../entities/product.entity';
import { Category } from '../../entities/category.entity';
import { BusinessSetting } from '../../entities/business-setting.entity';
export declare class PublicService {
    private readonly productRepo;
    private readonly categoryRepo;
    private readonly settingRepo;
    constructor(productRepo: Repository<Product>, categoryRepo: Repository<Category>, settingRepo: Repository<BusinessSetting>);
    getFeaturedProducts(): Promise<Product[]>;
    getAllCategories(): Promise<Category[]>;
    getProductsByCategory(categoryId: number): Promise<Product[]>;
    getBusinessSettings(): Promise<{}>;
    searchProducts(query: string): Promise<Product[]>;
}
